@extends('admin.layout.page-app')
@section('page_title', __('label.contest_leaderboard'))
@section('tab_title', __('label.contest_leaderboard'))

@section('content')
    @include('admin.layout.sidebar')

    <div class="right-content">
        @include('admin.layout.header')

        <div class="body-content">
            <!-- mobile title -->
            <h1 class="page-title-sm">{{__('label.contest_leaderboard')}}</h1>

            <div class="border-bottom row mb-3">
                <div class="col-sm-10">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{__('label.dashboard')}}</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.contests.index') }}">{{__('label.contests')}}</a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{__('label.contest_leaderboard')}}</li>
                    </ol>
                </div>
                <div class="col-sm-2 d-flex align-items-center justify-content-end">
                    <a href="{{ route('admin.contests.index') }}" class="btn btn-default mw-120" style="margin-top: -14px;">{{__('label.contests')}}</a>
                </div>
            </div>

            <div class="table-responsive">
                <table class="table table-striped text-center table-bordered" id="datatable">
                    <thead>
                        <tr>
                            <th>{{__('label.rank')}}</th>
                            <th>{{__('label.image')}}</th>
                            <th>{{__('label.name')}}</th>
                            <th>{{__('label.total_questions')}}</th>
                            <th>{{__('label.attended')}}</th>
                            <th>{{__('label.correct')}}</th>
                            <th>{{__('label.percentage')}}</th>
                            <th>{{__('label.winning_coin')}}</th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
        </div>
    </div>
@endsection

@section('pagescript')
    <script>
        $(document).ready(function() {
            var table = $('#datatable').DataTable({
                ...dataTableDefaults,
                ajax: {
                    url:'{{ route("admin.contests.leaderboard", [$contest_id]) }}',
                },
                columns: [
                    {
                        data: 'rank',
                        name: 'rank',
                        searchable: false,
                        render: function(data) {
                            return data ? data : "0";
                        }
                    },
                    {
                        data: 'user.image',
                        name: 'user.image',
                        orderable: false,
                        searchable: false,
                        render: function(data, type, full, meta) {
                            var imgUrl = data ? data : "{{ asset('assets/imgs/default.png') }}";
                            return `<a href="${imgUrl}" target="_blank"><img src="${imgUrl}" class="rounded-circle" style="height:55px; width:55px"></a>`;
                        },
                    },
                    {
                        data: 'user',
                        name: 'user',
                        orderable: false,
                        searchable: false,
                        render: function(data, type, row) {
                            return data ? `<div style="text-align: left;">${data.user_name || '-'}<br><span style="font-size: 14px; font-weight: 600;">${data.full_name || '-'}</span></div>` : '-';
                        }
                    },
                    {
                        data: 'total_questions',
                        name: 'total_questions',
                        render: function(data) {
                            return `<span style="font-size: 20px; font-weight: 600;">${data ?? 0}</span>`;
                        }
                    },
                    {
                        data: 'questions_attended',
                        name: 'questions_attended',
                        render: function(data) {
                            return `<span style="font-size: 20px; font-weight: 600;">${data ?? 0}</span>`;
                        }
                    },
                    {
                        data: 'correct_answers',
                        name: 'correct_answers',
                        render: function(data) {
                            return `<span style="font-size: 20px; font-weight: 600;" class="green-color">${data ?? 0}</span>`;
                        }
                    },
                    {
                        data: 'percentage',
                        name: 'percentage',
                        render: function(data) {
                            return `<span style="font-size: 20px; font-weight: 600;" class="primary-color">${data ?? 0}%</span>`;
                        }
                    },
                    {
                        data: 'winning_coin',
                        name: 'winning_coin',
                        render: function(data) {
                            return `<span style="font-size: 20px; font-weight: 600;" class="primary-color">${data ?? 0}<i class="fa-solid fa-sack-dollar ml-3 fa-lg"></i></span>`;
                        }
                    },
                ],
            });
        });
    </script>
@endsection